﻿using System;
using System.IO;
using System.Text;
using System.Collections.Generic;

using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Runtime.Serialization;
using System.Runtime.Serialization.Json;


// Note: JSON serialization require References to:
// - System.Runtime.Serialization
// - System.ServiceModel.Web


namespace mtweb
{

///////////////////////////////////////////////////////////

public static class Util
{

  // Recursive find first control of type 'T' with id 'ID'.
  // If 'ID' is NULL or empty only search by type.
  //
  public static T Find<T>(ControlCollection Controls, string ID)
    where T : System.Web.UI.Control
  {
    T found = null;
    if (Controls == null) return null;

    foreach (Control item in Controls)
    {
      if (found != null) break;

      if (item is T) {
        if (string.IsNullOrEmpty(ID)) {
          found = item as T; break;
        }
        else if (item.ID != null && item.ID.Equals(ID)) {
          found = item as T; break;
        }
        else if (item.ID != null && item.UniqueID.Equals(ID)) {
          found = item as T; break;
        }
        else if (item.ID != null && item.ClientID.Equals(ID)) {
          found = item as T; break;
        }
      }

      found = Util.Find<T>(item.Controls, ID);
    }

    return found;
  }


  // Serialize or deserialize a ParameterCollection

  public static string SerializePC(ParameterCollection pc)
  {
    if (pc == null) return null;  // error
    
    MemoryStream ms = new MemoryStream();
    IEnumerable<Type> ie = new[] {typeof(Parameter)};
    DataContractJsonSerializer ser = new DataContractJsonSerializer(pc.GetType(), ie);
    ser.WriteObject(ms, pc);
    string json = Encoding.Default.GetString(ms.ToArray());
    ms.Close();
    return json;
  }

  public static ParameterCollection DeserializePC(string json)
  {
    if (string.IsNullOrEmpty(json)) return null;  // error

    ParameterCollection pc = new ParameterCollection();
    byte[] b = Encoding.Default.GetBytes(json);
    MemoryStream ms = new MemoryStream(b);
    IEnumerable<Type> ie = new[] {typeof(Parameter)};
    DataContractJsonSerializer ser = new DataContractJsonSerializer(pc.GetType(), ie);
    pc = (ParameterCollection)ser.ReadObject(ms);
    ms.Close();
    return pc;
  }


  // Return an object as normalized string
  public static string normalize(Object o)
  {
    if (o == null || o == DBNull.Value) {
      return string.Empty;
    }
    return o.ToString().Trim();
  }


}  // class
}  // namespace

